/*
 * Decompiled with CFR 0.152.
 */
package io.github.overlordsiii.villagernames.command.suggestion;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.github.overlordsiii.villagernames.VillagerNames;
import io.github.overlordsiii.villagernames.config.NamesConfig;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2168;

public abstract class NameSuggestionProvider
implements SuggestionProvider<class_2168> {
    protected NamesConfig namesConfig;

    public CompletableFuture<Suggestions> getSuggestions(CommandContext<class_2168> context, SuggestionsBuilder builder) {
        String string = builder.getRemaining();
        this.sortNamesByString(string).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }

    private ArrayList<String> sortNamesByString(String currentArg) {
        ArrayList<String> suggestionsBasedOnCurrentArg = new ArrayList<String>();
        this.namesConfig.getNameList().forEach(string -> {
            if (string.indexOf(currentArg) == 0) {
                suggestionsBasedOnCurrentArg.add((String)string);
            }
        });
        return suggestionsBasedOnCurrentArg;
    }

    public static class PiglinSurname
    extends NameSuggestionProvider {
        public PiglinSurname() {
            this.namesConfig = VillagerNames.CONFIG.piglinSurnamesConfig;
        }
    }

    public static class Piglin
    extends NameSuggestionProvider {
        public Piglin() {
            this.namesConfig = VillagerNames.CONFIG.piglinNamesConfig;
        }
    }

    public static class Surename
    extends NameSuggestionProvider {
        public Surename() {
            this.namesConfig = VillagerNames.CONFIG.sureNamesConfig;
        }
    }

    public static class Golem
    extends NameSuggestionProvider {
        public Golem() {
            this.namesConfig = VillagerNames.CONFIG.golemNamesConfig;
        }
    }

    public static class Villager
    extends NameSuggestionProvider {
        public Villager() {
            this.namesConfig = VillagerNames.CONFIG.villagerNamesConfig;
        }
    }
}

